// File created by Sixten Hilborn

#include justapi.jss

// Add a function to be called when a specific event triggers
Host AddFunc(FuncName, Purpose);

// SetConf
Host SetConf(Variable, Value);

// GetConf
Host GetConf(Variable);

// Return time in ms for last frame, could be used for like DPS stuff like burning ground etc.
Host GetElapsed();

// Add a resource
Host AddResource(Type, File);

// Set level data
Host SetLevelData(Name, Background);

// Is the tile solid or not?
Host GetTileSolid(Name, X, Y);

// Add a map trigger
Host AddTrigger(LevelName, Function, x, y, w, h);

// Add a weapon to the weapon list
Host AddWeapon(Type, Name, Script, Anim, Cooldown, MaxAmmo);

// Equip a weapon for a player (if the ammo is negative, this works just like ammo, otherwise,
// if it's zero or positive, you'll get the weapon if you don't already have it + the ammo)
Host EquipWeapon(PlayerIndex, ItemName, Ammo);

// Returns number of maximum players on the server
Host GetMaxPly();

// Add an item to the item shop (Req, Bonus and ItemInfo must be arrays!)
Host AddItem(ItemType, Name, Price, Bitmap, Icon, Req, Bonus, ItemInfo);

// Add a spell to the spell shop (Req, Scripts and Actions must be arrays, where S&A size must be equal to NumActions)
Host AddSpell(Name, Price, Descript, Req, CastTime, ManaCost, CoolDown, NumActions, Scripts, Actions, ID, MaxLevel);

// Returns what level of the spell [ID] a character has (0 means not learned yet, > 0 is spell level
Host SpellLevel(PlayerIndex, ID);

// Get info about a player, such as level, strength, class etc.
Host PlayerInfo(PlayerIndex);

// Set the current mana of a player
Host SetCurrMana(PlayerIndex, Amount);

// Gives (sets) a player Amount gold
Host SetPlayerGold(PlayerIndex, Amount);

// Returns a player's entity id
Host GetPlayerEntity(PlayerIndex);

// Returns a player's index from entity id
Host GetPlayerIndex(EntityID);

// Returns a projectile's entity id
Host GetProjEntity(ID);

// Returns a powerup's entity id
Host GetPowerupEntity(ID);

// Get an entity's team
Host GetEntityTeam(ID);

// Returns a list of living entities (player characters & NPCs) within the radius
// of Range from center ( X , Y )
Host GetLivingEntities(Level, X, Y, Range);

// Get distance from a point to the border of an entity
Host DistanceToEntity(Id, X, Y);

// Get entity position, including velocity, map ("place") etc.
Host GetPos(ID);

// Set entity position, including velocity, map ("place") etc.
Host SetPos(ID, Position);

// Set entity graphical scaling
Host SetScale(ID, x, y);

// Set entity bounds
Host SetBounds(ID, x, y, w, h);

// Set entity health
Host SetHP(ID, HP);

// Set an action/event function of an NPC
Host SetNPCFunc(ID, Action, Function);

// Returns number of milliseconds a player as left to be stunned in
Host GetStun(PlayerIndex);

// Sets, in milliseconds, how long a player should be stunned
Host SetStun(PlayerIndex, Time);

// Adds a new power up to the game and returns the entity ID
/* Arguments:
 0 - Script (e.g. "scriptfile:function")
 1 - Powerup respawn time
 2 - X position
 3 - Y position
 4 - Map (spawns in which level?)
 5 - Animation
 6 - Flags
*/
Host AddPowerup(PowerupData); // (Script, RespawnTime, Flags);

// Adds a new projectile to the game and returns the projectile ID (not entity ID!)
Host AddProj(Position = 0);

// Add a new NPC and return the entity ID of it
Host AddNPC(Name, InitScript, Position = 0);

// Remove Projectile with ID
Host RemoveProj(ID);

// Get the custom data of a projectile (REFERENCE)
Host GetEntData(ID);

// Set custom data of projectile
Host SetEntData(ID, Data);

// Set some (sometimes) vital data for projectiles
Host SetProjInfo(ID, UpdateFunction, ImpactFunction, Binding);

// Get the damage that's gonna be dealt soooooon
Host GetCurrDmg();

// Set the damage to be dealt (as FLOAT) =)
Host SetCurrDmg(Damage);

// Deal damage to a player (can also HEAL if Damage (should be float) is negative! =))
Host DealDmg(Attacker, Target, Damage, Flags);

// SHOOP DA WOOP, IMMA CHARGIN' MY LAZOR    - Kjell
Host Lazer(Position, Direction, Attacker, Damage, AnimationInfo);

// Set colour of an entity
Host SetEntColour(ID, Time1, Colour1, Time2, Colour2);

// Play a sound for a client (Position might be -1 for a simple sound, or { Level, X, Y } to play the sound
// so it appear to come from a source in the ( X, Y ) position of map Level
// To play the sound for any/all clients, just put -1 as the second argument
Host PlaySound(SoundFile, PlayerIndex = -1, Position = 0, Volume = 128);

// Add a label
Host CreateLabel(Text, Place, X, Y, Time, R, G, B);

// Set a player invisible
Host SetInvis(PlayerIndex, Flag);

// Is a player invisible?
Host GetInvis(PlayerIndex);
