// File created by Sixten Hilborn

#include justapi.jss

// Add/remove a function to be called when a specific event triggers
Host AddFunc(FuncName, Purpose);
Host RemoveFunc(FuncName);


// Returns the opponent robot's ID
Host GetOpponent();

// Returns a list of living entities (player characters & NPCs) within the radius
// of Range from center ( X , Y )
Host GetLivingEntities(Level, X = 0, Y = 0, Range = 0);

// Whats the angle between entity1 and entity2 ?
Host DirectionOf(ID1, ID2);

// Get entity position, including velocity, map ("place") etc.
Host GetPos(ID);

// Sets x&y velocity
Host SetMovement(X_vel, Y_vel);

// Sets velocity and direction
Host SetDirection(Velocity, Angle);

// Add an animation to be used (where Filename and everything behind MUST BE ARRAYS with the size NumFrames)
Host AddAnim(Name, Length, NumFrames, Filename, X, Y, Width, Height, Flags);

// Add a point to an animation to connect two animations with each other
Host AddAnimPoint(Name, Frame, ID, X, Y, Rotation);

// Add a link from Name1 to Name2 (not both wais !) and draw at depth ZOrder
Host AddAnimLink(Name1, Name2, ZOrder);

// Remove a point
Host RemoveAnimPoint(Name, Frame, ID);

// Remove a link
Host RemoveAnimLink(Name1, Name2);
