// File created by Sixten Hilborn

#include serverapi.jss
#include effects.jss

Func Init(id) // The ID of this NPC
{
	Var Pos = GetPos(id);

	SetHP(id, 1);
	Pos[7] = 1;
	Pos[8] = "snowbomb";
	SetBounds(id, -50, -50, 100, 100);

	SetNPCFunc(id, 2, "npcs/snowbomb:death");

	SetPos(id, Pos);
	
	Var Data[1];
	SetEntData(id, Data);
}

Func death(npcId, killerId)
{
	Var Pos = GetPos(npcId);
	XPlode(killerId, Pos, 110.0, 50.0, 200.0, 2.0);
	
	Var ProjId = AddProj();
	Var Data[4];
	Data[0] = GetTime() + 5000;
	Data[1] = Pos[0];
	Data[2] = Pos[1];
	Data[3] = Pos[6];
	
	SetEntData(GetProjEntity(ProjId), Data);

	SetProjInfo(ProjId, "npcs/snowbomb:respawn", "", 0);
}

Func respawn(id)
{
	Var EntityID = GetProjEntity(id);
	Var Data = GetEntData(EntityID);
	
	// Get the difference between now and then
	if(GetTime() - Data[0] >= 0)
	{
		Var newPos[11]; // = GetPos(newId);

		newPos[0] = Data[1];
		newPos[1] = Data[2];
		newPos[6] = Data[3];
		newPos[8] = "snowbomb";
		
		Var newId = AddNPC("snowbomb", "npcs/snowbomb:init", newPos);
		
		return -1;
	}
	return 0;
}
