// File created by Sixten Hilborn

#include serverapi.jss
#include effects.jss

Func Init(id) // The ID of this NPC
{
	Var Pos = GetPos(id);

	SetHP(id, 200);
	Pos[2] = 100.0;
	Pos[7] = 1;
	if(!Pos[8])
		Pos[8] = "birdo";
	SetBounds(id, -50, -50, 100, 100);

	SetNPCFunc(id, 0, "npcs/birdo:update");
	SetNPCFunc(id, 1, "npcs/birdo:impact");
	SetNPCFunc(id, 2, "npcs/birdo:death");
	
	SetPos(id, Pos);
	
	Var Data[1];
	SetEntData(id, Data);
}

Func update(id) // The ID of this NPC
{
	Var Pos = GetPos(id);
		
	if(Pos[0] < 200 && Pos[2] < 0)
	{
		Pos[2] = 100.0;
		Pos[7] = 1;
	}
	
	if(Pos[0] > 2000 && Pos[2] > 0)
	{
		Pos[2] = -100.0;
		Pos[7] = 0;	
	}
	
	
	SetPos(id, Pos);
	
	return 0;
}

Func impact(npcId, who)
{
	if(Who >= 0)
	{
		Var Player = GetPlayerIndex(Who);
		if(Player < 0)
		{
			return 0;
		}
		Var Data = GetEntData(npcId);
		Data[0] += GetElapsed();
		Var Dmg = 0.0;
		while(Data[0] > 500)
		{
			Data[0] -= 250;
			Dmg += 10.0;
		}
		
		if(Dmg > 0.0)
			DealDmg(npcId, Who, Dmg, 0);
				
		SetEntData(npcId, Data);
	}
	
	return 0;
}

Func death(npcId, killerId)
{
	Var Pos = GetPos(npcId);
	XPlode(npcId, Pos, 110.0, 50.0, 300.0, 3.0);
	
	Var newPos[11]; // = GetPos(newId);
	
	newPos[0] = 260;
	newPos[1] = 364;
	newPos[2] = 100.0;
	newPos[6] = Pos[6];
	newPos[7] = 1;
	newPos[8] = "greenface";
	
	Var newId = AddNPC("Greenface", "npcs/birdo:init", newPos); // "Birdo"
	
}
