
Func createeffect(Animation, Length, x, y, Level, #id = -1)
{
	Var Data[1];
	Var Bounds[2];
	Var EntityID;
	
	Var Pos[13];
	Pos[0] = x;
	Pos[1] = y;
	Pos[6] = Level;
	Pos[8] = Animation;

	// Facing RIGHT - No mirror-blit, which would require more CPU
	Pos[7] = 1;

	// New projectile to "store" the effect
	if(id == -1)
	{
		id = AddProj(Pos);
		EntityID = GetProjEntity(id);
	}
	else
	{
		EntityID = GetProjEntity(id);
		Var OldPos = GetPos(EntityID);
		
		// Set the position of the effect
		SetPos(EntityID, Pos);
	}

	// Set the update function
	// ID, UpdateFunction, ImpactFunction, Binding
	SetProjInfo(id, "bullet:defaulteffect_upd", "", Bounds);

	// Set "finnishing time point"
	Data[0] = Length + GetTime();
	SetEntData(EntityID, Data);

	// Return the id ;>
	return id;
}



Func XPlode(Owner, Pos, MaxDmg, MinDmg, MaxRadius, Scale, #id = -1)
{
	// Var MaxPlayers = GetMaxPly();

	// GetLivingEntities

	Var EntityList = GetLivingEntities(Pos[6], Pos[0], Pos[1], MaxRadius);
	Var ListSize = ArraySize(EntityList);
	MaxDmg -= MinDmg;

	for(Var i = 0; i < ListSize; i += 1)
	// for(Var i = 0; i < MaxPlayers; i += 1)
	{
		// Var Entity = GetPlayerEntity(i);
		Var Entity = EntityList[i];
		
		if(Entity < 0)
			continue;

		Var Distance = DistanceToEntity(Entity, Pos[0], Pos[1]);
		Var Radius = MaxRadius - Distance;
				
		if(Radius > 0)
		{
			Var Damage = MaxDmg * Radius / MaxRadius + MinDmg;
			DealDmg(Owner, Entity, Damage, 0);
		}
	}

	Var SndPos[3];
	SndPos[0] = Pos[6];
	SndPos[1] = Pos[0];
	SndPos[2] = Pos[1];
	PlaySound("explosion.wav", -1, SndPos, 128);

	Var effectId = GetProjEntity(createeffect("explosion", 1000, Pos[0], Pos[1], Pos[6], id));
	
	SetScale(effectId, Scale, Scale);
}
