// File created by Sixten Hilborn

#include justapi.jss

// Add/remove a function to be called when a specific event triggers
Host AddFunc(FuncName, Purpose);
Host RemoveFunc(FuncName);

// Loads and returns a bitmap surface
Host GetSurf(Filename);

// Get the index of this client's character
Host GetMyNr();

// Get number of players the server supports
Host GetMaxPly();

// Get the name of a player
Host PlayerName(PlayerIndex);

// Get info about a player, such as level, strength, class etc.
Host PlayerInfo(PlayerIndex);

// Gets the difference between the left side of the map and the left side of what the screen is viewing
Host GetScroll();

// Get a players position, velocity etc.
Host PlayerPosition(PlayerIndex);

// Return an RGB array with the colour of the player's name
Host GetPlayerColor(PlayerIndex);

// Draw a line on a surface
Host DrawLine(X1, Y1, X2, Y2, Red, Green, Blue, Alpha);

// Draw a box on a surface
Host DrawBox(X1, Y1, X2, Y2, Red, Green, Blue, Alpha);

// Draw text to a surface
Host DrawText(X, Y, Text, Red, Green, Blue, Alpha);

// Draw a filled box on a surface
Host DrawFillBox(X1, Y1, X2, Y2, Red, Green, Blue, Alpha);

// Draw (blit) one surface to another
Host Blit(SrcSurface, SrcX, SrcY, Width, Height, DstSurface, DstX, DstY);

// Open a menu (0 is inventory, 1 is stats, 2 is spellbook)
Host OpenMenu(Which);

// Returns the required XP to get the next level @ level "Level"
Host NextLvlXP(Level);

// Add an animation to be used (where Filename and everything behind MUST BE ARRAYS with the size NumFrames)
Host AddAnim(Name, Length, NumFrames, Filename, X, Y, Width, Height, Flags);

// Add a point to an animation to connect two animations with each other
Host AddAnimPoint(Name, Frame, ID, X, Y, Rotation);

// Add a link from Name1 to Name2 (not both wais !) and draw at depth ZOrder
Host AddAnimLink(Name1, Name2, ZOrder);

// Remove a point
Host RemoveAnimPoint(Name, Frame, ID);

// Remove a link
Host RemoveAnimLink(Name1, Name2);
