// File created by Sixten Hilborn

#include clientapi.jss

Func AddAnim_CharIdle()
{
	// Set number of frames in the animation
	Var numframes = 1;

	// Create arrays with the size n
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;


	for(Var i = 0; i < numframes; i+=1)
	{
		// Set bitmap of each frame
		bitmap[i] = "char/idle/x1337-solider-stand0001.png";
		// Set X-value of each source-rectangle
		x[i] = 0;
		// Set Y-value of each source-rectangle
		y[i] = 0;
		// Set Width-value of each source-rectangle
		w[i] = 0;
		// Set Height-value of each source-rectangle
		h[i] = 0;
	}

	// Name, length, numframes, bitmaps, xs, ys, ws, hs
	AddAnim("char_idle", 1000.0, numframes, bitmap, x, y, w, h, 0);
	
	for(i = 0; i < numframes; i+=1)
	{
		AddAnimPoint("char_idle", i, 1, 33, 47, 0.0);
	}
}


Func AddAnim_CharIdle1()
{
	// Set number of frames in the animation
	Var numframes = 46;

	// Create arrays with the size n
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;


	// Set bitmap of each frame
	for(Var i = 0; i < numframes; i+=1)
	{
		bitmap[i] = "char/idle/x1337-solider-stand00";
		if(i < 9)
		{
			bitmap[i] $= "0";
		}
		bitmap[i] $= (i+1) $ ".png";
		
		x[i] = 0;
		y[i] = 0;
		w[i] = 64;
		h[i] = 64;
	}
		
	

	// Name, length, numframes, bitmaps, xs, ys, ws, hs
	AddAnim("char_idle1", 2000.0, numframes, bitmap, x, y, w, h, 0);
	
	for(i = 0; i < numframes; i+=1)
	{
		AddAnimPoint("char_idle1", i, 1, 50, 37, 0.0);
	}
}


Func AddAnim_CharWalk()
{
	
	Var numframes = 9;

	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
	{
		bitmap[i] = "char/run/x1337-solider-run0" $ (i+1) $ ".png";
	}
	
	for(i = 0; i < numframes; i+=1)
		x[i] = 0;

	for(i = 0; i < numframes; i+=1)
		y[i] = 0;
	
	for(i = 0; i < numframes; i+=1)
		w[i] = 64;
	
	for(i = 0; i < numframes; i+=1)
		h[i] = 64;
	
	AddAnim("char_walk", 600.0, numframes, bitmap, x, y, w, h, 0);
	
	for(i = 0; i < numframes; i+=1)
	{
		//AddAnimPoint("char_walk", i, 1, 50, 30, 0.0);
	}
	
	AddAnimPoint("char_walk", 0, 1, 7, 30, 0.0);
	AddAnimPoint("char_walk", 1, 1, 10, 34, 0.0);
	AddAnimPoint("char_walk", 2, 1, 35, 38, 0.0);
	AddAnimPoint("char_walk", 3, 1, 44, 32, 0.0);
	AddAnimPoint("char_walk", 4, 1, 14, 35, 0.0);
	AddAnimPoint("char_walk", 5, 1, 11, 23, 0.0);
	AddAnimPoint("char_walk", 6, 1, 19, 36, 0.0);
	AddAnimPoint("char_walk", 7, 1, 35, 38, 0.0);
	AddAnimPoint("char_walk", 8, 1, 18, 36, 0.0);
}

Func AddAnim_CharJump()
{
	// Set number of frames in the animation
	Var numframes = 1;

	// Create arrays with the size n
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;


	// Set bitmap of each frame
	for(Var i = 0; i < numframes; i+=1)
		bitmap[i] = "char/idle/x1337-solider-stand0001.png";

	// Set X-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		x[i] = 0;

	// Set Y-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		y[i] = 0;

	// Set Width-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		w[i] = 64;

	// Set Height-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		h[i] = 64;

	// Name, length, numframes, bitmaps, xs, ys, ws, hs
	AddAnim("char_jump", 300.0, numframes, bitmap, x, y, w, h, 0);
	
	for(i = 0; i < numframes; i+=1)
	{
		AddAnimPoint("char_jump", i, 1, 50, 37, 0.0);
	}
}


Func AddAnim_CharWallJump()
{
	// Set number of frames in the animation
	Var numframes = 1;

	// Create arrays with the size n
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;


	// Set bitmap of each frame
	for(Var i = 0; i < numframes; i+=1)
		bitmap[i] = "char/idle/x1337-solider-stand0001.png";

	// Set X-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		x[i] = (i + 1) * 100;

	// Set Y-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		y[i] = 200;

	// Set Width-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		w[i] = 64;

	// Set Height-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		h[i] = 64;

	// Name, length, numframes, bitmaps, xs, ys, ws, hs
	AddAnim("char_walljump", 300.0, numframes, bitmap, x, y, w, h, 0);
	
	for(i = 0; i < numframes; i+=1)
	{
		AddAnimPoint("char_walljump", i, 1, 50, 37, 0.0);
	}
}


Func AddAnim_CharDying()
{
	// Set number of frames in the animation
	Var numframes = 31;

	// Create arrays with the size n
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;


	// Set bitmap of each frame
	for(Var i = 0; i < numframes; i+=1)
	{
		bitmap[i] = "char/death/DEATH00";
		if(i < 9)
		{
			bitmap[i] $= "0";
		}
		bitmap[i] $= (i+1) $ ".png";
	}

	// Set X-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		x[i] = 0;

	// Set Y-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		y[i] = 0;
	
	// Set Width-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		w[i] = 120;

	// Set Height-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		h[i] = 100;

	// Name, length, numframes, bitmaps, xs, ys, ws, hs
	AddAnim("char_dying", 1000.0, numframes, bitmap, x, y, w, h, 0);
}

Func AddAnim_CharDead()
{
	// Set number of frames in the animation
	Var numframes = 1;

	// Create arrays with the size n
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;


	// Set bitmap of each frame
	for(Var i = 0; i < numframes; i+=1)
		bitmap[i] = "char/death/DEATH0032.png";

	// Set X-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		x[i] = 0;

	// Set Y-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		y[i] = 0;

	// Set Width-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		w[i] = 120;

	// Set Height-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		h[i] = 100;

	// Name, length, numframes, bitmaps, xs, ys, ws, hs
	AddAnim("char_dead", 1000.0, numframes, bitmap, x, y, w, h, 0);
}


Func AddAnim_CharJetpack()
{
	Var numframes = 6;

	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
		bitmap[i] = "char/jetpack/x1337-solider-JetPocX000" $ (i+1) $ ".png";
	
	for(i = 0; i < numframes; i+=1)
		x[i] = 0;

	for(i = 0; i < numframes; i+=1)
		y[i] = 0;
	
	for(i = 0; i < numframes; i+=1)
		w[i] = 64;
	
	for(i = 0; i < numframes; i+=1)
		h[i] = 80;
	
	AddAnim("char_jetpack", 250.0, numframes, bitmap, x, y, w, h, 0);
	
	
	AddAnimPoint("char_jetpack", 0, 1, 28, 35, 0.0);
	AddAnimPoint("char_jetpack", 1, 1, 28, 31, 0.0);
	AddAnimPoint("char_jetpack", 2, 1, 28, 30, 0.0);
	AddAnimPoint("char_jetpack", 3, 1, 28, 29, 0.0);
	AddAnimPoint("char_jetpack", 4, 1, 28, 30, 0.0);
	AddAnimPoint("char_jetpack", 5, 1, 28, 31, 0.0);

}


Func AddAnim_CharVictory()
{
	// Set number of frames in the animation
	Var numframes = 46;

	// Create arrays with the size n
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;


	// Set bitmap of each frame
	for(Var i = 0; i < numframes; i+=1)
	{
		bitmap[i] = "char/idle/x1337-solider-stand00";
		if(i < 9)
		{
			bitmap[i] $= "0";
		}
		bitmap[i] $= (i+1) $ ".png";
	}

	// Set X-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		x[i] = 0;

	// Set Y-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		y[i] = 0;

	// Set Width-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		w[i] = 64;

	// Set Height-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		h[i] = 64;

	// Name, length, numframes, bitmaps, xs, ys, ws, hs
	AddAnim("char_victory", 2000.0, numframes, bitmap, x, y, w, h, 0);
}

Func AddAnim_CharDefeat()
{
	// Set number of frames in the animation
	Var numframes = 1;

	// Create arrays with the size n
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;


	// Set bitmap of each frame
	for(Var i = 0; i < numframes; i+=1)
		bitmap[i] = "char/idle/x1337-solider-stand0001.png";

	// Set X-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		x[i] = 0;

	// Set Y-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		y[i] = 0;

	// Set Width-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		w[i] = 64;

	// Set Height-value of each source-rectangle
	for(i = 0; i < numframes; i+=1)
		h[i] = 64;

	// Name, length, numframes, bitmaps, xs, ys, ws, hs
	AddAnim("char_defeat", 1000.0, numframes, bitmap, x, y, w, h, 0);
}


Func AddAnim_Explosion()
{
	Var numframes = 31;

	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
	{
		bitmap[i] = "Exploding/Expo00";
		if(i < 9)
		{
			bitmap[i] $= "0";
		}
		bitmap[i] $= (i+1) $ ".png";
	}
	
	for(i = 0; i < numframes; i+=1)
		x[i] = 0;

	for(i = 0; i < numframes; i+=1)
		y[i] = 0;
	
	for(i = 0; i < numframes; i+=1)
		w[i] = 150;
	
	for(i = 0; i < numframes; i+=1)
		h[i] = 150;
	
	AddAnim("explosion", 1000.0, numframes, bitmap, x, y, w, h, 0);
}



Func AddAnim_Bullet()
{
	
	Var numframes = 1;

	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
		bitmap[i] = "bullet.png";
	
	for(i = 0; i < numframes; i+=1)
		x[i] = 0;

	for(i = 0; i < numframes; i+=1)
		y[i] = 0;
	
	for(i = 0; i < numframes; i+=1)
		w[i] = 8;
	
	for(i = 0; i < numframes; i+=1)
		h[i] = 8;
	
	AddAnim("bullet", 1000.0, numframes, bitmap, x, y, w, h, 0);
}


Func AddAnim_Health()
{
	
	Var numframes = 1;

	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
		bitmap[i] = "health.png";
	
	for(i = 0; i < numframes; i+=1)
		x[i] = 0;

	for(i = 0; i < numframes; i+=1)
		y[i] = 0;
	
	for(i = 0; i < numframes; i+=1)
		w[i] = 16;
	
	for(i = 0; i < numframes; i+=1)
		h[i] = 16;
	
	AddAnim("health", 1000.0, numframes, bitmap, x, y, w, h, 0);
}


Func AddAnim_PowerupDeathpulse()
{
	Var numframes = 1;
	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
		bitmap[i] = "death_pulse.png";
	
	for(i = 0; i < numframes; i+=1)
		x[i] = 0;

	for(i = 0; i < numframes; i+=1)
		y[i] = 0;
	
	for(i = 0; i < numframes; i+=1)
		w[i] = 16;
	
	for(i = 0; i < numframes; i+=1)
		h[i] = 16;
	
	AddAnim("deathpulse", 1000.0, numframes, bitmap, x, y, w, h, 0);
}

Func AddAnim_PowerupPistol()
{
	Var numframes = 1;
	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
		bitmap[i] = "weapons/Revolver.png";
	
	for(i = 0; i < numframes; i+=1)
		x[i] = 0;

	for(i = 0; i < numframes; i+=1)
		y[i] = 0;
	
	for(i = 0; i < numframes; i+=1)
		w[i] = 0;
	
	for(i = 0; i < numframes; i+=1)
		h[i] = 0;
	
	AddAnim("pistol", 1000.0, numframes, bitmap, x, y, w, h, 0);
	
	for(i = 0; i < numframes; i+=1)
	{
		AddAnimPoint("pistol", i, 1, 6, 6, 0.0);
	}
}


Func AddAnim_PowerupShotgun()
{
	Var numframes = 1;
	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
		bitmap[i] = "weapons/shotgun.png";
	
	for(i = 0; i < numframes; i+=1)
		x[i] = 0;

	for(i = 0; i < numframes; i+=1)
		y[i] = 0;
	
	for(i = 0; i < numframes; i+=1)
		w[i] = 50;
	
	for(i = 0; i < numframes; i+=1)
		h[i] = 19;
	
	AddAnim("shotgun", 1000.0, numframes, bitmap, x, y, w, h, 0);
	
	for(i = 0; i < numframes; i+=1)
	{
		AddAnimPoint("shotgun", i, 1, 13, 10, 0.0);
	}
}


Func AddAnim_PowerupMinigun()
{
	Var numframes = 1;
	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
		bitmap[i] = "weapons/minigun.png";
	
	for(i = 0; i < numframes; i+=1)
		x[i] = 0;

	for(i = 0; i < numframes; i+=1)
		y[i] = 0;
	
	for(i = 0; i < numframes; i+=1)
		w[i] = 0;
	
	for(i = 0; i < numframes; i+=1)
		h[i] = 0;
	
	AddAnim("minigun", 1000.0, numframes, bitmap, x, y, w, h, 0);
	
	for(i = 0; i < numframes; i+=1)
	{
		AddAnimPoint("minigun", i, 1, 19, 2, 0.0);
	}
}

Func AddAnim_PowerupRocketlauncher()
{
	Var numframes = 1;
	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
		bitmap[i] = "weapons/rocketlauncher.png";
	
	for(i = 0; i < numframes; i+=1)
		x[i] = 0;

	for(i = 0; i < numframes; i+=1)
		y[i] = 0;
	
	for(i = 0; i < numframes; i+=1)
		w[i] = 87;
	
	for(i = 0; i < numframes; i+=1)
		h[i] = 27;
	
	AddAnim("rocketlauncher", 1000.0, numframes, bitmap, x, y, w, h, 0);
	
	for(i = 0; i < numframes; i+=1)
	{
		AddAnimPoint("rocketlauncher", i, 1, 27, 19, 0.0);
	}
}


Func AddAnim_PowerupBfg9000()
{
	Var numframes = 1;
	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	bitmap[0] = "weapons/bfg9000.png";
	x[0] = 0;
	y[0] = 0;
	w[0] = 0;
	h[0] = 0;
	
	AddAnim("bfg9000", 1000.0, numframes, bitmap, x, y, w, h, 0);
	
	for(Var i = 0; i < numframes; i+=1)
	{
		AddAnimPoint("bfg9000", i, 1, 27, 19, 0.0);
	}
}

Func AddAnim_PowerupCrawler()
{
	Var numframes = 4;
	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	// Set bitmap of each frame
	for(Var i = 0; i < numframes; i+=1)
	{
		bitmap[i] = "weapons/crawler0";
		bitmap[i] $= (i+1) $ ".png";
		
		x[i] = 0;
		y[i] = 0;
		w[i] = 93;
		h[i] = 27;
	}
	
	AddAnim("crawler", 100.0, numframes, bitmap, x, y, w, h, 0);
	
	for(i = 0; i < numframes; i+=1)
	{
		AddAnimPoint("crawler", i, 1, 13, 15, 0.0);
	}
}

Func AddAnim_PowerupLandmine()
{
	Var numframes = 1;
	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
		bitmap[i] = "weapons/mine_box.png";
	
	x[0] = 0;
	y[0] = 0;
	w[0] = 0;
	h[0] = 0;
	
	AddAnim("mine_box", 1000.0, numframes, bitmap, x, y, w, h, 0);
}


Func AddAnim_PowerupRailgun()
{
	Var numframes = 1;
	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
		bitmap[i] = "weapons/Railgun.png";
	
	x[0] = 0;
	y[0] = 0;
	w[0] = 0;
	h[0] = 0;
	
	AddAnim("railgun", 1000.0, numframes, bitmap, x, y, w, h, 0);
	
	for(i = 0; i < numframes; i+=1)
	{
		AddAnimPoint("railgun", i, 1, 7, 15, 0.0);
	}
}


Func AddAnim_AmmoShotgun()
{
	Var numframes = 1;
	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
		bitmap[i] = "weapons/ammo01.png";
	
	for(i = 0; i < numframes; i+=1)
		x[i] = 0;

	for(i = 0; i < numframes; i+=1)
		y[i] = 0;
	
	for(i = 0; i < numframes; i+=1)
		w[i] = 40;
	
	for(i = 0; i < numframes; i+=1)
		h[i] = 20;
	
	AddAnim("ammo_shotgun", 1000.0, numframes, bitmap, x, y, w, h, 0);
}


Func AddAnim_AmmoRocket()
{
	Var numframes = 1;
	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
		bitmap[i] = "weapons/rocketammo.png";
	
	for(i = 0; i < numframes; i+=1)
		x[i] = 0;

	for(i = 0; i < numframes; i+=1)
		y[i] = 0;
	
	for(i = 0; i < numframes; i+=1)
		w[i] = 40;
	
	for(i = 0; i < numframes; i+=1)
		h[i] = 20;
	
	AddAnim("ammo_rocket", 1000.0, numframes, bitmap, x, y, w, h, 0);
}




Func AddAnim_ProjRocket()
{
	Var numframes = 3;
	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
	{
		bitmap[i] = "rocket0" $ (i + 1) $ ".png";
		x[i] = 0;
		y[i] = 0;
		w[i] = 0;
		h[i] = 0;
	}
	
	AddAnim("rocket", 400.0, numframes, bitmap, x, y, w, h, 1);
}


Func AddAnim_ProjCrawler()
{
	Var numframes = 4;
	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
		bitmap[i] = "lightningrazor.png";
	
	for(i = 0; i < numframes; i+=1)
	{
		x[i] = 75 * i;
		y[i] = 75;
		w[i] = 75;
		h[i] = 75;
	}
		
	AddAnim("proj_crawler", 500.0, numframes, bitmap, x, y, w, h, 0);
}

Func AddAnim_ProjPlasmaball()
{
	Var numframes = 1;
	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
	{
		bitmap[i] = "plasmaball.png";
		x[i] = 0;
		y[i] = 0;
		w[i] = 0;
		h[i] = 0;
	}
		
	AddAnim("plasmaball", 500.0, numframes, bitmap, x, y, w, h, 0);
}

Func AddAnim_ProjMine()
{
	Var numframes = 1;
	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	
	for(Var i = 0; i < numframes; i+=1)
	{
		bitmap[i] = "weapons/mine.png";
		x[i] = 0;
		y[i] = 0;
		w[i] = 0;
		h[i] = 0;
	}
		
	AddAnim("landmine", 500.0, numframes, bitmap, x, y, w, h, 0);
	
	for(i = 0; i < numframes; i+=1)
	{
		AddAnimPoint("landmine", i, 1, 3, 3, 0.0);
	}
}


Func AddAnim_ProjLazer()
{
	Var numframes = 1;
	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	
	for(Var i = 0; i < numframes; i+=1)
	{
		bitmap[i] = "weapons/Lazor.png";
		x[i] = 0;
		y[i] = 0;
		w[i] = 0;
		h[i] = 0;
	}
		
	AddAnim("lazer", 1000.0, numframes, bitmap, x, y, w, h, 0);
	
	for(i = 0; i < numframes; i+=1)
	{
		AddAnimPoint("lazer", i, 1, 20, 0, 0.0);
	}
}

Func AddAnim_Grenade()
{
	Var numframes = 1;
	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
		bitmap[i] = "weapons/granat1.PNG";
	
	for(i = 0; i < numframes; i+=1)
		x[i] = 0;

	for(i = 0; i < numframes; i+=1)
		y[i] = 0;
	
	w[0] = 20;
	h[0] = 20;
	
	AddAnim("grenade", 1000.0, numframes, bitmap, x, y, w, h, 0);
	
	for(i = 0; i < numframes; i+=1)
	{
		AddAnimPoint("grenade", i, 1, 3, 5, 0.0);
	}
}


Func AddAnim_SuperGrenade()
{
	Var numframes = 1;
	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
		bitmap[i] = "weapons/supergrenade.png";
	
	for(i = 0; i < numframes; i+=1)
		x[i] = 0;

	for(i = 0; i < numframes; i+=1)
		y[i] = 0;
	
	w[0] = 20;
	h[0] = 20;
	
	AddAnim("supergrenade", 1000.0, numframes, bitmap, x, y, w, h, 0);
	
	for(i = 0; i < numframes; i+=1)
	{
		AddAnimPoint("supergrenade", i, 1, 3, 5, 0.0);
	}
}

Func AddAnim_NukeGrenade()
{
	Var numframes = 1;
	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
		bitmap[i] = "weapons/granat2.PNG";
	
	for(i = 0; i < numframes; i+=1)
		x[i] = 0;

	for(i = 0; i < numframes; i+=1)
		y[i] = 0;
	
	w[0] = 0;
	h[0] = 0;
	
	AddAnim("nukegrenade", 1000.0, numframes, bitmap, x, y, w, h, 0);
	
	for(i = 0; i < numframes; i+=1)
	{
		AddAnimPoint("nukegrenade", i, 1, 3, 4, 0.0);
	}
}

Func AddAnim_Cluster()
{
	Var numframes = 1;
	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
		bitmap[i] = "clusterfuck.png";
	
	for(i = 0; i < numframes; i+=1)
		x[i] = 0;

	for(i = 0; i < numframes; i+=1)
		y[i] = 0;
	
	w[0] = 0;
	h[0] = 0;
	
	AddAnim("cluster", 1000.0, numframes, bitmap, x, y, w, h, 0);
}



Func AddAnim_NPCBirdo()
{
	Var numframes = 7;
	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
		bitmap[i] = "birdo/Birdo000" $ (i + 1) $ ".png";
	
	for(i = 0; i < numframes; i+=1)
		x[i] = 0;

	for(i = 0; i < numframes; i+=1)
		y[i] = 0;
	
	for(i = 0; i < numframes; i+=1)
	{
		w[i] = 100;
		h[i] = 100;
	}
	
	AddAnim("birdo", 400.0, numframes, bitmap, x, y, w, h, 0);
}



Func AddAnim_NPCGreenFace()
{
	Var numframes = 1;
	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;

	bitmap[0] = "GreenFace/Face.png";
	x[0] = 0;
	y[0] = 0;
	w[0] = 0;
	h[0] = 0;
	
	AddAnim("greenface", 1000.0, numframes, bitmap, x, y, w, h, 0);
	
	bitmap[0] = "GreenFace/Claw.png";
	AddAnim("greenface_leftclaw", 1000.0, numframes, bitmap, x, y, w, h, 0);
	AddAnim("greenface_rightclaw", 1000.0, numframes, bitmap, x, y, w, h, 0);
	
	bitmap[0] = "GreenFace/LeftHorn.png";
	AddAnim("greenface_lefthorn", 1000.0, numframes, bitmap, x, y, w, h, 0);
	bitmap[0] = "GreenFace/RightHorn.png";
	AddAnim("greenface_righthorn", 1000.0, numframes, bitmap, x, y, w, h, 0);
	

	AddAnimLink("greenface", "greenface_leftclaw", -1);
	AddAnimLink("greenface", "greenface_rightclaw", 1);

	// Name, Frame, ID, X, Y, Rotation
	AddAnimPoint("greenface", 0, 1, 9, 110, 0.0);
	AddAnimPoint("greenface", 0, 2, 90, 57, 0.0);
	AddAnimPoint("greenface_leftclaw", 0, 1, 35, 63, 0.0);
	AddAnimPoint("greenface_rightclaw", 0, 2, 2, 12, 0.0);
	
}

Func AddAnim_NPCSnowBomb()
{
	Var numframes = 1;

	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;

	for(Var i = 0; i < numframes; i+=1)
		bitmap[i] = "environment/snowbomb.png";

	for(i = 0; i < numframes; i+=1)
		x[i] = 0;

	for(i = 0; i < numframes; i+=1)
		y[i] = 0;

	for(i = 0; i < numframes; i+=1)
		w[i] = 0;

	for(i = 0; i < numframes; i+=1)
		h[i] = 0;

	AddAnim("snowbomb", 1000.0, numframes, bitmap, x, y, w, h, 0);

	for(i = 0; i < numframes; i+=1)
	{
		AddAnimPoint("snowbomb", i, 1, 20, 0, 0.0);
	}
}

Func AddAnim_Flags()
{
	
	Var numframes = 3;

	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
	{
		bitmap[i] = "flags.PNG";
		x[i] = 38 * i;
		y[i] = 0;
		w[i] = 38;
		h[i] = 75;
	}
	
	AddAnim("flag_blue", 400.0, numframes, bitmap, x, y, w, h, 0);
	
	y[0] = y[1] = y[2] = 75;
	AddAnim("flag_yellow", 400.0, numframes, bitmap, x, y, w, h, 0);

	y[0] = y[1] = y[2] = 150;
	AddAnim("flag_purple", 400.0, numframes, bitmap, x, y, w, h, 0);

	y[0] = y[1] = y[2] = 225;
	AddAnim("flag_red", 400.0, numframes, bitmap, x, y, w, h, 0);

	y[0] = y[1] = y[2] = 300;
	AddAnim("flag_green", 400.0, numframes, bitmap, x, y, w, h, 0);

	y[0] = y[1] = y[2] = 375;
	AddAnim("flag_white", 400.0, numframes, bitmap, x, y, w, h, 0);
}


Func AddAnim_Bases()
{
	
	Var numframes = 3;

	
	Var bitmap, x, y, w, h;
	resize bitmap, numframes;
	resize x, numframes;
	resize y, numframes;
	resize w, numframes;
	resize h, numframes;
	
	for(Var i = 0; i < numframes; i+=1)
	{
		bitmap[i] = "base.png";
		x[i] = 0;
		y[i] = 0;
		w[i] = 0;
		h[i] = 0;
	}
	
	AddAnim("base", 400.0, numframes, bitmap, x, y, w, h, 0);
	
	AddAnim("base_red", 400.0, numframes, bitmap, x, y, w, h, 0);

	AddAnim("base_blue", 400.0, numframes, bitmap, x, y, w, h, 0);
	
	
	AddAnimLink("base", "flag_white", -1);
	AddAnimLink("base_red", "flag_red", -1);
	AddAnimLink("base_blue", "flag_blue", -1);

	// Name, Frame, ID, X, Y, Rotation
	for(i = 0; i < numframes; i += 1)
	{
		AddAnimPoint("base", i, 1, 230, 155, 0.0);
		AddAnimPoint("flag_white", i, 1, 35, 74, 0.0);
		
		AddAnimPoint("base_red", i, 1, 230, 155, 0.0);
		AddAnimPoint("flag_red", i, 1, 35, 74, 0.0);
		
		AddAnimPoint("base_blue", i, 1, 230, 155, 0.0);
		AddAnimPoint("flag_blue", i, 1, 35, 74, 0.0);
	}
	
}


Func _Main()
{
	Print("Loading graphics and animations...");
	AddAnim_CharIdle();
	AddAnim_CharIdle1();
	AddAnim_CharWalk();
	AddAnim_CharJump();
	AddAnim_CharWallJump();
	AddAnim_CharDying();
	AddAnim_CharDead();
	AddAnim_CharJetpack();
	AddAnim_CharVictory();
	AddAnim_CharDefeat();
	AddAnim_Explosion();
	AddAnim_Bullet();
	AddAnim_Health();
	AddAnim_PowerupDeathpulse();
	AddAnim_PowerupPistol();
	AddAnim_PowerupShotgun();
	AddAnim_PowerupMinigun();
	AddAnim_PowerupCrawler();
	AddAnim_PowerupRocketlauncher();
	AddAnim_PowerupBfg9000();
	AddAnim_PowerupLandmine();
	AddAnim_PowerupRailgun();
	AddAnim_AmmoShotgun();
	AddAnim_AmmoRocket();
	AddAnim_ProjRocket();
	AddAnim_ProjCrawler();
	AddAnim_ProjPlasmaball();
	AddAnim_ProjMine();
	AddAnim_ProjLazer();
	AddAnim_Grenade();
	AddAnim_SuperGrenade();
	AddAnim_NukeGrenade();
	AddAnim_Cluster();
	AddAnim_NPCBirdo();
	AddAnim_NPCGreenFace();
	AddAnim_NPCSnowBomb();
	AddAnim_Flags();
	AddAnim_Bases();

	Print("Done!\n");
	// AddAnimLink("char_idle", "arrow");
}
